
/**
 ******************************************************************************
 *
 * @file        MG32_LCM_API.h
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _MG32_LCM_API_H_
#define _MG32_LCM_API_H_


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_GPIO_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
//!@{
//! defgroup LCM control Pin
#define API_LCM_RS      PC10
#define API_LCM_RW      PC9
#define API_LCM_EN      PC8
#define API_DATA_BUS    GPIOA->OUT.B[1]
///@}

//!@{
//! defgroup LCM Command
#define WriteCommand    0
#define ReadCommand     1
#define RegisterSelect  0
#define DataSelect      1
#define ActiveEN        1
#define DeactiveEN      0
#define FunctionSet     0x3F
#define DisplayOff      0x08
#define DisplayClear    0x01
#define EntryMode       0x06
#define LCMAddrCmd      0x80
#define DispayON        0x0C
#define ReturnHome      0x02
#define firstLine       0x00
#define SecondLine      0x40
//!@}

/* Private macro -------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief       Write LCM command/Data to LCM Bus.
 * @param[in]   __CMD__ : LCM command.
 * @return		None.
 *******************************************************************************
 */
#define API_LCM_WRITE_TO_BUS(__CMD__)       API_DATA_BUS = __CMD__


/**
 *******************************************************************************
 * @brief       Trigger LCM_EN plus.
 * @param[in]   None.
 * @return		None.
 *******************************************************************************
 */
#define API_LCM_TRIGGER()       __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                API_LCM_EN = ActiveEN; \
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                API_LCM_EN = DeactiveEN; \
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP();\
                                __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP(); __NOP()

/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/**
 * @name    Function announce
 * @brief   Time base initial/Deinitial	
 */ 
///@{
void API_LCM_Init(void);
/* Blocking mode: Polling */
void API_LCM_Display(uint8_t LCMAddr, uint8_t *String);
void API_LCM_Clear(void);

///@}

/**
 * @name    Function announce
 * @brief   LCM private function
 */ 
///@{
void API_LCM_WriteCMD(uint8_t CMD);
void API_LCM_WriteData(uint8_t Data);
///@}

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

#endif

